package vieropeenrij;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.MouseListener;
import java.util.Observable;

/**
 * This class represents the user interface of the game. It shows all changes
 * that occur in the related VorMatrix object.
 * @author  Kris Luyten
 */
public class VierOpEenRijVenster extends javax.swing.JFrame implements java.util.Observer{
    
    private VorBucket[][] $vorLabels = new VorBucket[VierOpEenRij.COLS][VierOpEenRij.ROWS];
    

    /** Creates new form VierOpEenRijVenster */
    public VierOpEenRijVenster() {
        initComponents();
        addLabels();   
    }

    /**
     * This method returns the column in which a bucket can be found.
     * @param bucket the buckt for which we search the corresponding column
     * @return the column in which bucket can be found
     * @throws NoSuchColumnException when bucket is not a part of any column
     * @pre bucket != null
     */
    int getColumn(VorBucket bucket) throws NoSuchColumnException {
         for(int i=0; i<VierOpEenRij.ROWS;i++)
            for(int j=0; j<VierOpEenRij.COLS;j++){
                if($vorLabels[j][i] == bucket)
                    return j;         
            }
         throw new NoSuchColumnException(bucket);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        strategyGroup = new javax.swing.ButtonGroup();
        Toolbar = new javax.swing.JToolBar();
        newButton = new javax.swing.JButton();
        jRadioButtonHuman = new javax.swing.JRadioButton();
        jRadioButtonLtR = new javax.swing.JRadioButton();
        jRadioButtonRandom = new javax.swing.JRadioButton();
        vorPanel = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Four in a Row");

        Toolbar.setRollover(true);

        newButton.setText("New");
        newButton.setFocusable(false);
        newButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        newButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        newButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                newButtonActionPerformed(evt);
            }
        });
        Toolbar.add(newButton);

        strategyGroup.add(jRadioButtonHuman);
        jRadioButtonHuman.setSelected(true);
        jRadioButtonHuman.setText("vs Human");
        jRadioButtonHuman.setFocusable(false);
        jRadioButtonHuman.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jRadioButtonHuman.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        jRadioButtonHuman.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jRadioButtonHuman.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonHumanActionPerformed(evt);
            }
        });
        Toolbar.add(jRadioButtonHuman);

        strategyGroup.add(jRadioButtonLtR);
        jRadioButtonLtR.setText("vs Left-to-Right");
        jRadioButtonLtR.setFocusable(false);
        jRadioButtonLtR.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jRadioButtonLtR.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        jRadioButtonLtR.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jRadioButtonLtR.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonLtRActionPerformed(evt);
            }
        });
        Toolbar.add(jRadioButtonLtR);

        strategyGroup.add(jRadioButtonRandom);
        jRadioButtonRandom.setText("vs Randomized");
        jRadioButtonRandom.setFocusable(false);
        jRadioButtonRandom.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jRadioButtonRandom.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        jRadioButtonRandom.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jRadioButtonRandom.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonRandomActionPerformed(evt);
            }
        });
        Toolbar.add(jRadioButtonRandom);

        vorPanel.setLayout(new java.awt.GridLayout(6, 7, 1, 1));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(Toolbar, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 588, Short.MAX_VALUE)
                .add(120, 120, 120))
            .add(layout.createSequentialGroup()
                .add(20, 20, 20)
                .add(vorPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 668, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(Toolbar, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 33, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(vorPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 442, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void newButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newButtonActionPerformed
        VierOpEenRij.getInstance().newGame();
    }//GEN-LAST:event_newButtonActionPerformed

    private void jRadioButtonHumanActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonHumanActionPerformed
        VierOpEenRij.getInstance().setAgainst(null);
    }//GEN-LAST:event_jRadioButtonHumanActionPerformed

    private void jRadioButtonLtRActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonLtRActionPerformed
       VierOpEenRij.getInstance().setAgainst(new LtRVorStrategy());
    }//GEN-LAST:event_jRadioButtonLtRActionPerformed

    private void jRadioButtonRandomActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonRandomActionPerformed
        VierOpEenRij.getInstance().setAgainst(new RandomVorStrategy());
    }//GEN-LAST:event_jRadioButtonRandomActionPerformed

    /**
     * creates new VorBucket objects that are presented in the user interface
     */
    private void addLabels(){
        vorPanel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
         for(int i=VierOpEenRij.ROWS-1; i>=0 ;i--)
            for(int j=0; j<VierOpEenRij.COLS;j++){
                $vorLabels[j][i] = new VorBucket();
                vorPanel.add($vorLabels[j][i]);
            }
        pack();
    }

    /**
     * Adds a mouselistener to each separate VorBucket object in the user interface. Each VorBucket object
     * is responsible for sending the mouselistener events it receives.
     * @param l the mouselistener that is passed on the the individual objects
     */
    @Override
    public synchronized void addMouseListener(MouseListener l) {
         for(int i=0; i<VierOpEenRij.ROWS;i++)
            for(int j=0; j<VierOpEenRij.COLS;j++){
                $vorLabels[j][i].addMouseListener(l);
            }
    }
    
    

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JToolBar Toolbar;
    private javax.swing.JRadioButton jRadioButtonHuman;
    private javax.swing.JRadioButton jRadioButtonLtR;
    private javax.swing.JRadioButton jRadioButtonRandom;
    private javax.swing.JButton newButton;
    private javax.swing.ButtonGroup strategyGroup;
    private javax.swing.JPanel vorPanel;
    // End of variables declaration//GEN-END:variables

    /**
     * Updates the user interface according to the object passed on to this method
     * @param o the object being observed by this instance of VierOpEenRijVenster
     * @param arg the update data send by object o
     */
    public void update(Observable o, Object arg) {
        if(arg == null)
            checkAll((VorMatrix)o);
        else{
            java.awt.Point p = (java.awt.Point)arg;
            $vorLabels[p.x][p.y].setFill(((VorMatrix)o).getFill(p.x,p.y));
        }
        repaint();
    }

    /**
     * Simple check the makes the user interface consistent with the datamodel
     * @param v the datamodel that needs to be represented in the user interface
     */
    private void checkAll(VorMatrix v){
        for(int i=0; i<VierOpEenRij.ROWS;i++)
            for(int j=0; j<VierOpEenRij.COLS;j++)
                $vorLabels[j][i].setFill(v.getFill(j, i));
    }

}
